document.getElementById('shareButton').addEventListener('click', async () => {
  let [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  let url = tab.url;

  let oEmbedURL = `https://www.youtube.com/oembed?url=${encodeURIComponent(url)}&format=json`;

  try {
    let response = await fetch(oEmbedURL);
    if (!response.ok) throw new Error('oEmbed request failed');

    let data = await response.json();
    let title = data.title;

    chrome.tabs.sendMessage(tab.id, {
      action: "show_modal",
      title: title,
      url: url
    });

    window.close();

  } catch (error) {
    console.error(error);
    document.getElementById('status').textContent = 'Error fetching title.';
  }
});
